% Road
%-------------------------------------------------------------------------
% Witten By Tomas Mauder, VUT v Brne, 2014.
%-------------------------------------------------------------------------
road = struct;


%-------------------------------------------------------------------------
%   trida cesty              phi0 * 10^-6
%   A (velmi dobra)          1   
%   B (dobra)                4
%   C (prumerna)             16   
%   D (spatna)               64  
%   E (velmi spatna)         256

road.type_x = 4;
road.type_x = road.type_x * 10^-6;
%-------------------------------------------------------------------------
% interval vlnoveho cisla pro PSD
road.omega0_x = 1; % referencni vlna
road.omega1_x = 0.063; % nejkratsi vlna
road.omega2_x = 60; % nejdelsi vlna
road.omega_cut = 0.001; % nastavi pozici minimalniho mista kde bude PSD orezano
%-------------------------------------------------------------------------
% Koeficient zvlneni (waviness);
% Dlouhe vlny
road.wL_x = 2;
% Kratke vlny
road.wS_x = 2;
%-------------------------------------------------------------------------
% Delka cesty (m)
% zacatek
road.L1_x = 0; 
road.L1_y = 0; 
% konec
road.L2_x = 100;
road.L2_y = 2;
% Pocet vzorku na 1 m cesty
road.N_x = 5;
road.N_y = 4;
% Rozdeleni cesty na L * N intervalu
road.sx = [road.L1_x:1/road.N_x:(road.L2_x-1/road.N_x) road.L2_x];
% Rozdeleni cesty na L * N intervalu
road.sy = [road.L1_y:1/road.N_y:(road.L2_y-1/road.N_y) road.L2_y];
%-------------------------------------------------------------------------
% pocet vln pro PSD
% road.M_x = 1000;
road.M_x = size(road.omega1_x: 1/(road.L2_x - road.L1_x + road.L2_y - road.L1_y): road.omega2_x,2);



